<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../include/utilEcommerce.php";
    include "../../gUtil/DbManager.php";
    include "../../gUtil/GestoreUpload.php";
    include "../../gUtil/ControlloreStringhe.php";
    include "../../gUtil/ElaboratoreImmagini.php";
    include "../../classi/GeneratoreUrl.php";
    include "../../classi/ecommerce/Spedizione.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $datiGeecomCms = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $urlAreaAmministrativa = GeneratoreUrl::creaUrlAreaAmministrativa(recuperaImpostazioni($geecomDb), $datiGeecomCms);
    
    if(isset($_GET["operazione"])) {
	$operazione   = filter_input(INPUT_GET, "operazione", FILTER_SANITIZE_STRING);
	$idSpedizione = filter_input(INPUT_GET, "id", FILTER_SANITIZE_NUMBER_INT);
    }
    else {
	$operazione   = filter_input(INPUT_POST, "operazione", FILTER_SANITIZE_STRING);
	$idSpedizione = (isset($_POST["id"])) ? filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    $spedizione = new Spedizione($geecomDb, $idSpedizione);
    
    if($operazione=="elimina") {
        $spedizione->elimina();
	echo "ok";
    }
    else if($operazione=="crea") {
        $spedizione->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setDisponibile(filter_input(INPUT_POST,"disponibile",FILTER_SANITIZE_STRING));
        $spedizione->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setCosto(filter_input(INPUT_POST,"costo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setCostoZoneDisagiate(filter_input(INPUT_POST,"costoZoneDisagiate",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setAreaGeografica(filter_input(INPUT_POST,"areaGeografica",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setImportoMinimoCarrello(filter_input(INPUT_POST,"importoMinimoCarrello",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setGiorniNecessari(filter_input(INPUT_POST,"giorniNecessari",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setGiorniInCuiSiSpedisce(filter_input(INPUT_POST,"giorniInCuiSiSpedisce",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setOrarioLimite(filter_input(INPUT_POST,"orarioLimite",FILTER_SANITIZE_ADD_SLASHES));
        $idSpedizione = $spedizione->crea();
        header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaSpedizione.php?id=$idSpedizione&status=200");
    }
    else if($operazione=="modifica") {
        $spedizione->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setDisponibile(filter_input(INPUT_POST,"disponibile",FILTER_SANITIZE_STRING));
        $spedizione->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setCosto(filter_input(INPUT_POST,"costo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setCostoZoneDisagiate(filter_input(INPUT_POST,"costoZoneDisagiate",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setAreaGeografica(filter_input(INPUT_POST,"areaGeografica",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setImportoMinimoCarrello(filter_input(INPUT_POST,"importoMinimoCarrello",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $spedizione->setGiorniNecessari(filter_input(INPUT_POST,"giorniNecessari",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->setGiorniInCuiSiSpedisce(filter_input(INPUT_POST,"giorniInCuiSiSpedisce",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->setOrarioLimite(filter_input(INPUT_POST,"orarioLimite",FILTER_SANITIZE_ADD_SLASHES));
        $spedizione->modifica();
        header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaSpedizione.php?id={$spedizione->getId()}&status=220");
    }
    else if($operazione=="aggiungiFasciaDiPrezzo") {
        $pesoMinimo  = filter_input(INPUT_POST,"pesoMinimo",FILTER_SANITIZE_NUMBER_INT);
        $pesoMassimo = filter_input(INPUT_POST,"pesoMassimo",FILTER_SANITIZE_NUMBER_INT);
        $costo              = filter_input(INPUT_POST,"costo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
        $costoZoneDisagiate = filter_input(INPUT_POST,"costoZoneDisagiate",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
        $spedizione->aggiungiFasciaDiPrezzo($pesoMinimo,$pesoMassimo,$costo,$costoZoneDisagiate);
        echo "ok";
    }
    else if($operazione=="modificaFasciaDiPrezzo") {
        $idFascia  = filter_input(INPUT_POST,"idFascia",FILTER_SANITIZE_NUMBER_INT);
        $pesoMinimo  = filter_input(INPUT_POST,"pesoMinimo",FILTER_SANITIZE_NUMBER_INT);
        $pesoMassimo = filter_input(INPUT_POST,"pesoMassimo",FILTER_SANITIZE_NUMBER_INT);
        $costo              = filter_input(INPUT_POST,"costo",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
        $costoZoneDisagiate = filter_input(INPUT_POST,"costoZoneDisagiate",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
        $spedizione->modificaFasciaDiPrezzo($idFascia,$pesoMinimo,$pesoMassimo,$costo,$costoZoneDisagiate);
        echo "ok";
    }
    else if($operazione=="eliminaFasciaDiPrezzo") {
        $idFascia  = filter_input(INPUT_POST,"idFascia",FILTER_SANITIZE_NUMBER_INT);
        $spedizione->eliminaFasciaDiPrezzo($idFascia);
        echo "ok";
    }
    else if($operazione=="stampaFasceDiPrezzo") {
        $spedizione->stampaFasceDiPrezzo();
    }
    else if($operazione=="stampaAreeGeografiche") {
        stampaAreeGeografiche($geecomDb);
    }
    else if($operazione=="modificaImpostazioniAreeGeografiche") {
        $attivaAreaeGeografiche = filter_input(INPUT_POST,"attivaAreaeGeografiche",FILTER_SANITIZE_STRING);
        $nazioniDaVisualizzare  = filter_input(INPUT_POST,"nazioniDaVisualizzare",FILTER_SANITIZE_STRING);
        
        $query = "UPDATE geecEc_impostazioni SET attivaAreeGeografiche='$attivaAreaeGeografiche', nazioniDaVisualizzare='$nazioniDaVisualizzare' WHERE id=1";
        $geecomDb->eseguiQueryScrittura($query);
        echo "ok";
    }
    else if($operazione=="creaAreaGeografica") {
        $nomeAreaGeografica  = filter_input(INPUT_POST,"nomeAreaGeografica",FILTER_SANITIZE_STRING);
        $nazioniAppartenenti = filter_input(INPUT_POST,"nazioniAppartenenti",FILTER_SANITIZE_STRING);
        
        $query = "INSERT INTO geecEc_areeGeografiche VALUES(NULL,'$nomeAreaGeografica','$nazioniAppartenenti');";
        $geecomDb->eseguiQueryScrittura($query);
        echo "ok";
    }
    else if($operazione=="modificaAreaGeografica") {
        $idArea              = filter_input(INPUT_POST,"idArea",FILTER_SANITIZE_NUMBER_INT);
        $nomeAreaGeografica  = filter_input(INPUT_POST,"nomeAreaGeografica",FILTER_SANITIZE_STRING);
        $nazioniAppartenenti = filter_input(INPUT_POST,"nazioniAppartenenti",FILTER_SANITIZE_STRING);
        $query = "UPDATE geecEc_areeGeografiche SET nome='$nomeAreaGeografica', nazioni='$nazioniAppartenenti' WHERE id=$idArea";
        $geecomDb->eseguiQueryScrittura($query);
        echo "ok";
    }
    else if($operazione=="eliminaAreaGeografica") {
        $id = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
        $geecomDb->eseguiQueryCancellazione("geecEc_areeGeografiche", $id);
        echo "ok";
    }
    else if($operazione=="stampaZoneDisagiate") {
        stampaZoneDisagiate($geecomDb);
    }
    else if($operazione=="creaZonaDisagiata") {
        $nome      = filter_input(INPUT_POST,"nomeZonaDisagiata",FILTER_SANITIZE_ADD_SLASHES);
        $CAPinizio = filter_input(INPUT_POST,"CAPinizio",FILTER_SANITIZE_STRING);
        $CAPfine   = filter_input(INPUT_POST,"CAPfine",FILTER_SANITIZE_STRING);
        $query = "INSERT INTO geecEc_zoneDisagiate VALUES(NULL,'$nome','$CAPinizio','$CAPfine');";
        $geecomDb->eseguiQueryScrittura($query);
        echo "ok";
    }
    else if($operazione=="modificaZonaDisagiata") {
        $idZona    = filter_input(INPUT_POST,"idZona",FILTER_SANITIZE_NUMBER_INT);
        $nome      = filter_input(INPUT_POST,"nomeZonaDisagiata",FILTER_SANITIZE_ADD_SLASHES);
        $CAPinizio = filter_input(INPUT_POST,"CAPinizio",FILTER_SANITIZE_NUMBER_INT);
        $CAPfine   = filter_input(INPUT_POST,"CAPfine",FILTER_SANITIZE_NUMBER_INT);
        $query     = "UPDATE geecEc_zoneDisagiate SET nome='$nome', capInizio='$CAPinizio', capFine='$CAPfine' WHERE id=$idZona";
        $geecomDb->eseguiQueryScrittura($query);
        echo "ok";
    }
    else if($operazione=="eliminaZonaDisagiata") {
        $id = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
        $geecomDb->eseguiQueryCancellazione("geecEc_zoneDisagiate", $id);
        echo "ok";
    }